/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.module;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import vazkii.quark.base.module.QuarkModule;

public enum ModuleCategory {
    AUTOMATION("automation", Items.f_42451_),
    BUILDING("building", Items.f_41995_),
    MANAGEMENT("management", Items.f_42009_),
    TOOLS("tools", Items.f_42385_),
    TWEAKS("tweaks", Items.f_42715_),
    WORLD("world", Items.f_42276_),
    MOBS("mobs", Items.f_42630_),
    CLIENT("client", Items.f_42545_),
    EXPERIMENTAL("experimental", Items.f_41996_),
    ODDITIES("oddities", Items.f_42730_, "quarkoddities");

    public final String name;
    public final Item item;
    public final String requiredMod;
    public boolean enabled;
    private List<QuarkModule> ownedModules = new ArrayList<QuarkModule>();

    private ModuleCategory(String name, Item item, String requiredMod) {
        this.name = name;
        this.item = item;
        this.requiredMod = requiredMod;
        this.enabled = true;
    }

    private ModuleCategory(String name, Item item) {
        this(name, item, null);
    }

    public void addModule(QuarkModule module) {
        this.ownedModules.add(module);
    }

    public List<QuarkModule> getOwnedModules() {
        return this.ownedModules;
    }

    public boolean isAddon() {
        return this.requiredMod != null;
    }
}

